/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.CaptureRtpSender;
import net.sourceforge.peers.media.DtmfFactory;
import net.sourceforge.peers.media.Echo;
import net.sourceforge.peers.media.FileReader;
import net.sourceforge.peers.media.IncomingRtpReader;
import net.sourceforge.peers.media.RtpSender;
import net.sourceforge.peers.media.SoundSource;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sip.core.useragent.UserAgent;

public class MediaManager {
    public static final int DEFAULT_CLOCK = 8000;
    private UserAgent userAgent;
    private CaptureRtpSender captureRtpSender;
    private IncomingRtpReader incomingRtpReader;
    private RtpSession rtpSession;
    private DtmfFactory dtmfFactory;
    private Logger logger;
    private DatagramSocket datagramSocket;
    private FileReader fileReader;
    private String destFileName;

    public MediaManager(UserAgent userAgent, Logger logger) {
        this.userAgent = userAgent;
        this.logger = logger;
        this.dtmfFactory = new DtmfFactory();
    }

    private void startRtpSessionOnSuccessResponse(String localAddress, String remoteAddress, int remotePort, Codec codec, SoundSource soundSource) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(localAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + localAddress, e);
            return;
        }
        this.rtpSession = new RtpSession(inetAddress, this.datagramSocket, this.userAgent.isMediaDebug(), this.logger, this.userAgent.getPeersHome());
        try {
            inetAddress = InetAddress.getByName(remoteAddress);
            this.rtpSession.setRemoteAddress(inetAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + remoteAddress, e);
        }
        this.rtpSession.setRemotePort(remotePort);
        try {
            this.captureRtpSender = new CaptureRtpSender(this.rtpSession, soundSource, this.userAgent.isMediaDebug(), codec, this.logger, this.userAgent.getPeersHome());
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            return;
        }
        try {
            this.captureRtpSender.start();
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
    }

    public void successResponseReceived(String localAddress, String remoteAddress, int remotePort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: {
                AbstractSoundManager soundManager = this.userAgent.getSoundManager();
                soundManager.init();
                this.startRtpSessionOnSuccessResponse(localAddress, remoteAddress, remotePort, codec, soundManager);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.captureRtpSender.getRtpSession(), soundManager, codec, this.logger, this.userAgent.getPeersHome(), "media");
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
            case echo: {
                Echo echo;
                try {
                    echo = new Echo(this.datagramSocket, remoteAddress, remotePort, this.logger);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host amongst " + localAddress + " or " + remoteAddress);
                    return;
                }
                this.userAgent.setEcho(echo);
                Thread echoThread = new Thread((Runnable)echo, Echo.class.getSimpleName());
                echoThread.start();
                break;
            }
            case file: {
                String fileName = this.userAgent.getConfig().getMediaFile();
                this.fileReader = new FileReader(fileName, this.logger);
                this.startRtpSessionOnSuccessResponse(localAddress, remoteAddress, remotePort, codec, this.fileReader);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.captureRtpSender.getRtpSession(), null, codec, this.logger, this.userAgent.getPeersHome(), "media");
                    this.destFileName = this.incomingRtpReader.getWavFileName();
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
        }
    }

    private void startRtpSession(String destAddress, int destPort, Codec codec, SoundSource soundSource) {
        this.rtpSession = new RtpSession(this.userAgent.getConfig().getLocalInetAddress(), this.datagramSocket, this.userAgent.isMediaDebug(), this.logger, this.userAgent.getPeersHome());
        try {
            InetAddress inetAddress = InetAddress.getByName(destAddress);
            this.rtpSession.setRemoteAddress(inetAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + destAddress, e);
        }
        this.rtpSession.setRemotePort(destPort);
        try {
            this.captureRtpSender = new CaptureRtpSender(this.rtpSession, soundSource, this.userAgent.isMediaDebug(), codec, this.logger, this.userAgent.getPeersHome());
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            return;
        }
        try {
            this.captureRtpSender.start();
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
    }

    public void handleAck(String destAddress, int destPort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: {
                AbstractSoundManager soundManager = this.userAgent.getSoundManager();
                soundManager.init();
                this.startRtpSession(destAddress, destPort, codec, soundManager);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.rtpSession, soundManager, codec, this.logger, this.userAgent.getPeersHome(), "media");
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
            case echo: {
                Echo echo;
                try {
                    echo = new Echo(this.datagramSocket, destAddress, destPort, this.logger);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host amongst " + this.userAgent.getConfig().getLocalInetAddress().getHostAddress() + " or " + destAddress);
                    return;
                }
                this.userAgent.setEcho(echo);
                Thread echoThread = new Thread((Runnable)echo, Echo.class.getSimpleName());
                echoThread.start();
                break;
            }
            case file: {
                if (this.fileReader != null) {
                    this.fileReader.close();
                }
                String fileName = this.userAgent.getConfig().getMediaFile();
                this.fileReader = new FileReader(fileName, this.logger);
                this.startRtpSession(destAddress, destPort, codec, this.fileReader);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.rtpSession, null, codec, this.logger, this.userAgent.getPeersHome(), "media");
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
        }
    }

    public void updateRemote(String destAddress, int destPort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: {
                try {
                    InetAddress inetAddress = InetAddress.getByName(destAddress);
                    this.rtpSession.setRemoteAddress(inetAddress);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host: " + destAddress, e);
                }
                this.rtpSession.setRemotePort(destPort);
                break;
            }
            case echo: {
                break;
            }
            case file: {
                try {
                    InetAddress inetAddress = InetAddress.getByName(destAddress);
                    this.rtpSession.setRemoteAddress(inetAddress);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host: " + destAddress, e);
                }
                this.rtpSession.setRemotePort(destPort);
                break;
            }
        }
    }

    public void sendDtmf(char digit) {
        if (this.captureRtpSender != null) {
            List<RtpPacket> rtpPackets = this.dtmfFactory.createDtmfPackets(digit);
            RtpSender rtpSender = this.captureRtpSender.getRtpSender();
            rtpSender.pushPackets(rtpPackets);
        }
    }

    public void stopSession() {
        if (this.rtpSession != null) {
            this.rtpSession.stop();
            while (!this.rtpSession.isSocketClosed()) {
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException e) {
                    this.logger.debug("sleep interrupted");
                }
            }
            this.rtpSession = null;
        }
        if (this.incomingRtpReader != null) {
            this.incomingRtpReader = null;
        }
        if (this.captureRtpSender != null) {
            this.captureRtpSender.stop();
            this.captureRtpSender = null;
        }
        if (this.datagramSocket != null) {
            this.datagramSocket = null;
        }
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: {
                AbstractSoundManager soundManager = this.userAgent.getSoundManager();
                if (soundManager == null) break;
                soundManager.close();
                break;
            }
            case echo: {
                Echo echo = this.userAgent.getEcho();
                if (echo == null) break;
                echo.stop();
                this.userAgent.setEcho(null);
                break;
            }
            case file: {
                this.fileReader.close();
                break;
            }
        }
    }

    public void setDatagramSocket(DatagramSocket datagramSocket) {
        this.datagramSocket = datagramSocket;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public FileReader getFileReader() {
        return this.fileReader;
    }

    public String getWavFileName() {
        return this.destFileName;
    }
}

